var Database = {
    options: {
        fullScreen: false,
        masterVolume: 70,
        musicVolume: 30,
        sfxVolume: 100,
        zoomLevel: {title: '50%', value: 1},
        installedMods: [],
        autoSaveInterval: 10000,
        language: null,
        hasCompletedWelcome: false,
        completedAchievements: []
    },
    newGameSettings: {
        date: new Date(new Date().getFullYear(), 0, 1, 8, 0, 0),
        started: false,
        gameover: false,
        state: 1,
        paused: true,
        lastVersion: `${Configuration.BETA_VERSION}.${Configuration.BETA_SUBVERSION}`,
        balance: 0,
        transactions: [],

        lastPricePerHour: 100,

        candidates: [],
        unassignedEmployees: [],

        activatedBenefits: [],
        office: {
            buildingName: BuildingNames.CheapBuilding,
            workstations: [],
            items: [],
        },

        completedEvents: [],
        mails: [],

        inventory: {},

        contracts: [],
        maxContractHours: 5,
        products: [],

        notifications: [],

        xp: 0,

        firedEmployees: [],
        resignedEmployees: [],
        researchInventory: [
            {
                frameworkName: FrameworkNames.NoFramework,
                researchPoints: Helpers.CalculateRequiredResearchPoints(null, FrameworkNames.NoFramework)
            },
            {
                featureName: FeatureNames.LandingPage,
                researchPoints: Helpers.CalculateRequiredResearchPoints(FeatureNames.LandingPage, null)
            }
        ],

        loans: [
            {
                provider: 'Eazy Money',
                tier: 1,
                amount: 40000,
                days: 365,
                interest: 30,
                dailyPayment: 128.2,
                // Dynamics
                daysLeft: 0,
                amountLeft: 0,
                active: false,
            },
            {
                provider: 'Global Loans',
                tier: 3,
                amount: 70000,
                days: 365,
                interest: 30,
                dailyPayment: 224.3,
                // Dynamics
                daysLeft: 0,
                amountLeft: 0,
                active: false,
            },
            {
                provider: 'Fever Inc',
                tier: 5,
                amount: 120000,
                days: 365,
                interest: 25,
                dailyPayment: 374.96,
                // Dynamics
                daysLeft: 0,
                amountLeft: 0,
                active: false,
            }
        ]
    },
    items: [
        {
            id: 1,
            name: "vase1",
            imagePath: "3dmodels/office_upgrades/vase1-{orientation}.png",
            price: 100,
            bonus: 0.5,
            width: 1,
            height: 1,
            tier: 1,
            placementOffset: [
                {top: -182, left: 142},
                {top: -192, left: 149},
                {top: -188, left: 143},
                {top: -192, left: 149}
            ]
        },
        {
            id: 2,
            name: "vase2",
            imagePath: "3dmodels/office_upgrades/vase2-{orientation}.png",
            price: 100,
            bonus: 0.5,
            width: 1,
            height: 1,
            tier: 5,
            placementOffset: [
                {top: -222, left: 172},
                {top: -222, left: 177},
                {top: -222, left: 172},
                {top: -222, left: 177}
            ]
        },
        {
            id: 3,
            name: "closet1",
            imagePath: "3dmodels/office_upgrades/closet1-{orientation}.png",
            price: 1000,
            bonus: 1,
            width: 1,
            height: 2,
            tier: 1,
            placementOffset: [
                {top: -492, left: 80},
                {top: -496, left: -81},
                {top: -519, left: 74},
                {top: -521, left: -81}
            ]
        },
        {
            id: 4,
            name: "small_closet1",
            imagePath: "3dmodels/office_upgrades/small_closet1-{orientation}.png",
            price: 500,
            bonus: 0.5,
            width: 1,
            height: 1,
            tier: 2,
            placementOffset: [
                {top: -265, left: 90},
                {top: -265, left: 66},
                {top: -265, left: 90},
                {top: -265, left: 66}
            ]
        },
        {
            id: 5,
            name: "couch_blue1",
            imagePath: "3dmodels/office_upgrades/couch_blue1-{orientation}.png",
            price: 1500,
            bonus: 1.5,
            width: 1,
            height: 3,
            tier: 2,
            placementOffset: [
                {top: -391, left: 120},
                {top: -396, left: -160},
                {top: -391, left: 120},
                {top: -396, left: -160},
            ]
        },
        {
            id: 6,
            name: "bench_red1",
            imagePath: "3dmodels/office_upgrades/bench_red1-{orientation}.png",
            price: 800,
            bonus: 0.5,
            width: 1,
            height: 2,
            tier: 3,
            placementOffset: [
                {top: -256, left: 115},
                {top: -254, left: -15},
                {top: -256, left: 115},
                {top: -254, left: -15},
            ]
        },
        {
            id: 7,
            name: "small_bench_red1",
            imagePath: "3dmodels/office_upgrades/small_bench_red1-{orientation}.png",
            price: 400,
            bonus: 0.25,
            width: 1,
            height: 1,
            tier: 4,
            placementOffset: [
                {top: -166, left: 124},
                {top: -166, left: 130},
                {top: -166, left: 130},
                {top: -166, left: 130},
            ]
        },
        {
            id: 8,
            name: "meeting_table1",
            imagePath: "3dmodels/office_upgrades/meeting_table1-{orientation}.png",
            price: 3000,
            bonus: 5,
            width: 3,
            height: 6,
            tier: 9,
            placementOffset: [
                {top: -746, left: -135},
                {top: -756, left: -526},
                {top: -746, left: -135},
                {top: -756, left: -526},
            ]
        },
        {
            id: 9,
            name: "table_and_chairs1",
            imagePath: "3dmodels/office_upgrades/table_and_chairs1-{orientation}.png",
            price: 1500,
            bonus: 5,
            width: 2,
            height: 4,
            tier: 4,
            placementOffset: [
                {top: -458, left: 113},
                {top: -465, left: -260},
                {top: -500, left: 34},
                {top: -510, left: -170},
            ]
        },
        {
            id: 10,
            name: "watercooler1",
            imagePath: "3dmodels/office_upgrades/watercooler1-{orientation}.png",
            price: 250,
            bonus: 1,
            width: 1,
            height: 1,
            tier: 5,
            placementOffset: [
                {top: -292, left: 106},
                {top: -292, left: 106},
                {top: -292, left: 106},
                {top: -292, left: 106},
            ]
        },
        {
            id: 11,
            name: "reception_area1",
            imagePath: "3dmodels/office_upgrades/reception_area1-{orientation}.png",
            price: 2500,
            bonus: 3,
            width: 3,
            height: 3,
            tier: 11,
            placementOffset: [
                {top: -443, left: -117},
                {top: -443, left: -117},
                {top: -443, left: -117},
                {top: -443, left: -117},
            ]
        },
        {
            id: 12,
            name: "coffe_closet1",
            imagePath: "3dmodels/office_upgrades/coffe_closet1-{orientation}.png",
            price: 500,
            bonus: 3,
            width: 1,
            height: 1,
            tier: 2,
            placementOffset: [
                {top: -265, left: 90},
                {top: -265, left: 66},
                {top: -265, left: 90},
                {top: -265, left: 66},
            ]
        },
        {
            id: 13,
            name: "couch_black1",
            imagePath: "3dmodels/office_upgrades/couch_black1-{orientation}.png",
            price: 2000,
            bonus: 2,
            width: 1,
            height: 1,
            tier: 8,
            placementOffset: [
                {top: -272, left: 90},
                {top: -272, left: 66},
                {top: -272, left: 90},
                {top: -272, left: 66},
            ]
        },
        {
            id: 14,
            name: "couch_black2",
            imagePath: "3dmodels/office_upgrades/couch_black2-{orientation}.png",
            price: 4000,
            bonus: 3,
            width: 1,
            height: 2,
            tier: 8,
            placementOffset: [
                {top: -308, left: 70},
                {top: -308, left: -58},
                {top: -308, left: 70},
                {top: -308, left: -58},
            ]
        },
        {
            id: 15,
            name: "tv_stand1",
            imagePath: "3dmodels/office_upgrades/tv_stand1-{orientation}.png",
            price: 1200,
            bonus: 4,
            width: 1,
            height: 1,
            tier: 8,
            placementOffset: [
                {top: -423, left: 130},
                {top: -423, left: 130},
                {top: -423, left: 130},
                {top: -423, left: 130},
            ]
        },
        {
            id: 16,
            name: "whiteboard2",
            imagePath: "3dmodels/office_upgrades/whiteboard2-{orientation}.png",
            price: 500,
            bonus: 5,
            width: 1,
            height: 2,
            tier: 4,
            placementOffset: [
                {top: -443, left: 142},
                {top: -443, left: 12},
                {top: -443, left: 142},
                {top: -443, left: 12},
            ]
        },
        {
            id: 17,
            name: "glass_wall1",
            imagePath: "3dmodels/office_upgrades/glass_wall1-{orientation}.png",
            price: 200,
            bonus: 0.1,
            width: 1,
            height: 1,
            tier: 1,
            placementOffset: [
                {top: -513, left: 50},
                {top: -513, left: 50},
                {top: -513, left: 50},
                {top: -513, left: 50},
            ]
        },
        {
            id: 18,
            name: "glass_wall_corner1",
            imagePath: "3dmodels/office_upgrades/glass_wall_corner1-{orientation}.png",
            price: 200,
            bonus: 0.1,
            width: 1,
            height: 1,
            tier: 1,
            placementOffset: [
                {top: -569, left: 50},
                {top: -532, left: 110},
                {top: -499, left: 50},
                {top: -534, left: -12},
            ]
        },
        {
            id: 19,
            name: "glass_wall_t1",
            imagePath: "3dmodels/office_upgrades/glass_wall_t1-{orientation}.png",
            price: 200,
            bonus: 0.1,
            width: 1,
            height: 1,
            tier: 1,
            placementOffset: [
                {top: -516, left: 54},
                {top: -512, left: 51},
                {top: -516, left: 54},
                {top: -512, left: 51},
            ]
        },
        {
            id: 20,
            name: "glass_wall_x1",
            imagePath: "3dmodels/office_upgrades/glass_wall_x1-{orientation}.png",
            price: 200,
            bonus: 0.1,
            width: 1,
            height: 1,
            tier: 1,
            placementOffset: [
                {top: -514, left: 50},
                {top: -514, left: 50},
                {top: -514, left: 50},
                {top: -514, left: 50},
            ]
        },
        {
            id: 21,
            name: "vending_machine1",
            imagePath: "3dmodels/office_upgrades/vending_machine1-{orientation}.png",
            price: 800,
            bonus: 4,
            width: 1,
            height: 2,
            tier: 7,
            placementOffset: [
                {top: -502, left: 63},
                {top: -499, left: -76},
                {top: -502, left: 63},
                {top: -499, left: -76},
            ]
        },
        {
            id: 22,
            name: "ping_pong_table1",
            imagePath: "3dmodels/office_upgrades/ping_pong_table1-{orientation}.png",
            price: 700,
            bonus: 4,
            width: 2,
            height: 4,
            tier: 10,
            placementOffset: [
                {top: -512, left: 52},
                {top: -512, left: -256},
                {top: -512, left: 52},
                {top: -512, left: -256},
            ]
        },
        {
            id: 23,
            name: "large_coffee_machine1",
            imagePath: "3dmodels/office_upgrades/large_coffee_machine1-{orientation}.png",
            price: 5700,
            bonus: 9,
            width: 1,
            height: 2,
            tier: 10,
            placementOffset: [
                {top: -353, left: 121},
                {top: -352, left: -6},
                {top: -353, left: 121},
                {top: -352, left: -6},
            ]
        },
        {
            id: 24,
            name: "lounge_chair1",
            imagePath: "3dmodels/office_upgrades/lounge_chair1-{orientation}.png",
            price: 1000,
            bonus: 2,
            width: 1,
            height: 1,
            tier: 9,
            placementOffset: [
                {top: -260, left: 65},
                {top: -260, left: 52},
                {top: -283, left: 68},
                {top: -292, left: 52},
            ]
        },
        {
            id: 25,
            name: "wall1",
            imagePath: "3dmodels/office_upgrades/wall1-{orientation}.png",
            price: 200,
            bonus: 0.1,
            width: 1,
            height: 1,
            tier: 8,
            placementOffset: [
                {top: -513, left: 50},
                {top: -513, left: 50},
                {top: -513, left: 50},
                {top: -513, left: 50},
            ]
        },
        {
            id: 26,
            name: "wall_corner1",
            imagePath: "3dmodels/office_upgrades/wall_corner1-{orientation}.png",
            price: 200,
            bonus: 0.1,
            width: 1,
            height: 1,
            tier: 8,
            placementOffset: [
                {top: -569, left: 50},
                {top: -532, left: 110},
                {top: -499, left: 50},
                {top: -534, left: -12},
            ]
        },
        {
            id: 27,
            name: "wall_t1",
            imagePath: "3dmodels/office_upgrades/wall_t1-{orientation}.png",
            price: 200,
            bonus: 0.1,
            width: 1,
            height: 1,
            tier: 8,
            placementOffset: [
                {top: -516, left: 54},
                {top: -512, left: 51},
                {top: -516, left: 54},
                {top: -512, left: 51},
            ]
        },
        {
            id: 28,
            name: "wall_x1",
            imagePath: "3dmodels/office_upgrades/wall_x1-{orientation}.png",
            price: 200,
            bonus: 0.1,
            width: 1,
            height: 1,
            tier: 8,
            placementOffset: [
                {top: -514, left: 50},
                {top: -514, left: 50},
                {top: -514, left: 50},
                {top: -514, left: 50},
            ]
        },
    ],
    workstationTypes: [
        {
            id: 1,
            tier: 1,
            name: 'BeginnerWorkstation',
            price: 3000,
            bonus: 1
        },
        {
            id: 2,
            tier: 4,
            name: 'IntermediateWorkstation',
            price: 5500,
            bonus: 2
        },
        {
            id: 3,
            tier: 10,
            name: 'ExpertWorkstation',
            price: 7000,
            bonus: 4
        }
    ],
    benefits: [
        {
            id: 'ae998ff3-66ac-4fd1-b147-d89c5080942e',
            tier: 3,
            name: 'SmallRetirementPlan',
            description: 'smallretirementplan_description',
            pricePerEmployee: 5,
            fixedPrice: 0,
            bonus: 5,
            active: false
        },
        {
            id: '24ce8845-53d7-4677-97b0-9d2f1883ef3d',
            tier: 5,
            name: 'FreeBeverages',
            description: 'freebeverages_description',
            pricePerEmployee: 2,
            fixedPrice: 200,
            bonus: 5,
            active: false
        },
        {
            id: 'bd78310a-f80f-40c0-83cb-6a23bd8e2782',
            tier: 8,
            name: 'FreeGymMembership',
            description: 'freegymmembership_description',
            pricePerEmployee: 1,
            fixedPrice: 0,
            bonus: 2,
            active: false
        },
        {
            id: 'd0ca2c69-64f7-4d20-a8c1-15cef1fb91dd',
            tier: 9,
            name: 'ExtendedRetirementPlan',
            description: 'extendedretirementplan_description',
            pricePerEmployee: 10,
            fixedPrice: 0,
            bonus: 10,
            active: false
        },
        {
            id: '87dd36bb-a5fe-41b0-b6e1-c3cf3c29e614',
            tier: 11,
            name: 'FreeHealthCare',
            description: 'freehealthcare_description',
            pricePerEmployee: 8,
            fixedPrice: 0,
            bonus: 10,
            active: false
        },
        {
            id: '5909ef7e-4e39-4c8a-b4ec-1e84befbd06b',
            tier: 13,
            name: 'FullRetirementPlan',
            description: 'fullretirementplan_description',
            pricePerEmployee: 12,
            fixedPrice: 0,
            bonus: 5,
            active: false
        },
        {
            id: 'cb5b3b39-dbbb-4823-a93e-d243e7d3319a',
            tier: 15,
            name: 'PaidTransportation',
            description: 'paidtransportation_description',
            pricePerEmployee: 7,
            fixedPrice: 0,
            bonus: 3,
            active: false
        }
    ],
};

function GetNewSettings() {
    let settings = Helpers.Clone(Database.newGameSettings);
    settings.id = chance.guid().substring(0, 10);

    return settings;
}

const EmployeeTypes = [
    {
        name: EmployeeTypeNames.SalesExecutive,
        group: Enums.EmployeeTypeGroups.Sales,
        tier: 1,
        description: 'salesexecutive_description'
    },

    {
        name: EmployeeTypeNames.Developer,
        group: Enums.EmployeeTypeGroups.Development,
        tier: 1,
        description: 'developer_description'
    },
    {
        name: EmployeeTypeNames.Designer,
        group: Enums.EmployeeTypeGroups.Development,
        tier: 2,
        description: 'designer_description'
    },
    {
        name: EmployeeTypeNames.Manager,
        group: Enums.EmployeeTypeGroups.Management,
        tier: 3,
        description: 'manager_description'
    },
    {
        name: EmployeeTypeNames.LeadDeveloper,
        group: Enums.EmployeeTypeGroups.Development,
        tier: 4,
        description: 'leaddeveloper_description'

    },
    {
        name: EmployeeTypeNames.Researcher,
        group: Enums.EmployeeTypeGroups.Management,
        tier: Configuration.TIER_FOR_PRODUCT_CREATION,
        description: 'researcher_description'
    },
    {
        name: EmployeeTypeNames.HrManager,
        group: Enums.EmployeeTypeGroups.Management,
        tier: 7,
        description: 'hrmanager_description'
    },
    {
        name: EmployeeTypeNames.DevOps,
        group: Enums.EmployeeTypeGroups.Development,
        tier: 6,
        description: 'devops_description'
    },
    {
        name: EmployeeTypeNames.Marketer,
        group: Enums.EmployeeTypeGroups.Sales,
        tier: 8,
        description: 'marketer_description'
    },
];

Database.competitors = [
    {name: 'UberCode', competitiveness: 1},
    {name: 'DevDevs', competitiveness: 1},
    {name: 'Errorless', competitiveness: 1.2},
    {name: 'Superstar Devs', competitiveness: 1.3},
    {name: 'CodeCodeCode Inc', competitiveness: 1.4},
    {name: 'WeKnowWeb', competitiveness: 1.5},
    {name: 'Code House', competitiveness: 1.6}
];

Database.languages = [
    {name: 'English', key: 'en', path: 'languages/en.json'},
    {name: 'German', key: 'de', path: 'languages/de.json'},
    {name: 'Spanish', key: 'es', path: 'languages/es.json'},
    {name: 'French', key: 'fr', path: 'languages/fr.json'},
    {name: 'Portuguese (Brazilian)', key: 'br', path: 'languages/br.json'},
    {name: 'Simplified Chinese', key: 'cn', path: 'languages/cn.json'},
];
